clear;
clc;
//WINDOWS 10 64-BIT OS , Scilab and toolbox versions 6.1.0.

//Scheduling algorithms deals to minimize queuing delay and to optimize performance of queuing environment. In this analysis, some common scheduling algorithms like First Come First Serve (FCFS), Shortest Job First (SJF) and Round Robin (RR) Scheduling are studied and reviewed on the basis of their working strategy


//Functions to be loaded
exec("fcfs_wt_awt.sci"); // fcfs_wt_awt.sci dependency file
exec("sjf_wt_awt.sci"); // sjf_wt_awt.sci dependency file 
exec("rr_wt_awt.sci");  // rr_wt_awt.sci dependency file

    num=4; //no of processes P1,P2,P3,P4
    bt=[10 2 8 6]; //Sample burst time
    wt=zeros(1,num); //waiting time
    tat=zeros(1,num); //turn around time

disp("Graphical Analysis- Waiting Time vs Average Waiting Time of Scheduling Algorithms");

disp("Burst time of the given Process P1=10, P2=2, P3=8, P4=6");

disp('Waiting Time of each Process in FCFS'); //displaying the waiting time in FCFS

fcfs = firstcomefirstserve(num,bt,wt,tat)    // Calling first come first serve function 


disp('Waiting time of each Process in SJF'); //displaying the Waiting time of each Process in SJF
sjf = shortestjobfirst(num,bt,wt,tat)    // Calling shortest job first function


disp('Waiting Time of each Process in Round Robin'); //displaying the Waititing Time of each Process in Round Robin

rr= roundrobin(num,bt,wt,tat)            // Calling Round Robin function

/*constructing a rows for graphical representation*/

scf(1);

y = [0,10,20,30,40];

x=[1,2,3,4,5]
avg = [0,16,12;10,0,5;12,8,15;20,2,15;10.5,6.5,11.75];

/*Matrix avg is set of values obtained from waiting time for each algorithm FCFS, SJF, RR respectively*/

xtitle('Graphical Analysis: Waiting Time Vs Average Waiting Time','Process','Waiting time');

bar(x,avg);

legend("FCFS","SJF","RR");
